﻿using System;
using System.Collections.Generic;
using System.Text;

namespace KursBeispiele
{
    public class Mod3
    {
        //Definition eines eigenen Ereignisses
        public event EventHandler ValueChanged;

        public Mod3(int value)
        {
            this.value = value % 3;
        }

        int value;

        public int Value
        {
            get { return this.value; }
            //Hier können wir gleich eigene Events in Aktion sehen
            set { this.value = value % 3; if (ValueChanged != null) ValueChanged(this, new EventArgs()); }
        }

        //Casts ermöglichen
        public static explicit operator int(Mod3 x)
        {
            return x.value;
        }

        public static implicit operator Mod3(int x)
        {
            return new Mod3(x);
        }

        //Mathematische Operatoren überladen
        public static Mod3 operator +(Mod3 x, Mod3 y)
        {
            return new Mod3(x.value + y.value);
        }

        public static Mod3 operator *(Mod3 x, Mod3 y)
        {
            return new Mod3(x.value * y.value);
        }

        //Indexoperator überladen - hier mit get und set
        public bool this[int index]
        {
            get { return value == (index % 3); }
            set { if (value) { Value = index % 3; } }
        }

        //Dies ist die Überladung einer Funktion
        public override string ToString()
        {
            return value.ToString();
        }
    }
}
